(*
Based on Apple's Summarize Message Script

This script takes the selected messages and reads the entire message.
*)

tell application "Mail"
	set selectedMessages to selection
	
	set selectionCount to (count of selectedMessages)
	if selectionCount is greater than 1 then
		set speakString to "There are " & selectionCount & " selected messages." & return
	else if selectionCount is equal to 1 then
		set speakString to "There is " & selectionCount & " selected message." & return
	else -- selectionCount is less than or equal to 0
		set speakString to "There are no selected messages."
	end if
	
	repeat with messageNumber from 1 to selectionCount
		set theMessage to item messageNumber of selectedMessages
		set speakString to (speakString & " message " & (messageNumber as string) & ": " & content of theMessage as string) & return
	end repeat
end tell
say speakString